<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$games_themes = readJSON(GAMES_THEMES_FILE);
$message = '';

// Salvar alterações nos temas
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_themes'])) {
    foreach ($_POST['themes'] as $key => $theme_data) {
        if (isset($games_themes[$key])) {
            $games_themes[$key]['name'] = $theme_data['name'];
            $games_themes[$key]['bg_color'] = $theme_data['bg_color'];
            $games_themes[$key]['description'] = $theme_data['description'];
        }
    }
    writeJSON(GAMES_THEMES_FILE, $games_themes);
    $message = 'Temas atualizados com sucesso!';
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Temas para Jogos - VOD Generator</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        /* Mesmos estilos do dashboard */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f5f5;
            display: flex;
        }
        
        .sidebar {
            width: 250px;
            background: <?php echo COLOR_METALIC; ?>;
            color: white;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            overflow-y: auto;
        }
        
        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h3 {
            color: <?php echo COLOR_NEON; ?>;
            margin-top: 10px;
        }
        
        .menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .menu li {
            padding: 10px 20px;
            transition: background 0.3s;
        }
        
        .menu li:hover {
            background: rgba(0,255,255,0.1);
        }
        
        .menu li.active {
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
        }
        
        .menu li a {
            color: white;
            text-decoration: none;
            display: block;
        }
        
        .menu li i {
            margin-right: 10px;
            width: 20px;
        }
        
        .main-content {
            margin-left: 250px;
            flex: 1;
            padding: 20px;
        }
        
        .top-menu {
            background: white;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .page-title {
            color: <?php echo COLOR_METALIC; ?>;
            font-size: 24px;
            font-weight: bold;
        }
        
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .themes-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }
        
        .theme-card {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            border: 2px solid #e0e0e0;
        }
        
        .theme-preview {
            width: 100%;
            height: 100px;
            border-radius: 10px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 24px;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #666;
            font-weight: 500;
        }
        
        .form-group input {
            width: 100%;
            padding: 8px;
            border: 2px solid #e0e0e0;
            border-radius: 5px;
        }
        
        .btn {
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
        }
        
        .message {
            padding: 15px;
            background: #d4edda;
            color: #155724;
            border-radius: 5px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="sidebar-header">
            <i class="fas fa-film" style="font-size: 40px; color: <?php echo COLOR_NEON; ?>;"></i>
            <h3>VOD Cards</h3>
        </div>
        
        <ul class="menu">
            <li><a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a></li>
            <li><a href="gerar_cards.php"><i class="fas fa-plus-circle"></i> Cards VOD</a></li>
            <li><a href="gerar_jogos.php"><i class="fas fa-futbol"></i> Cards Jogos</a></li>
            <li><a href="temas_vod.php"><i class="fas fa-palette"></i> Temas VOD</a></li>
            <li class="active"><a href="temas_jogos.php"><i class="fas fa-palette"></i> Temas Jogos</a></li>
            <li><a href="biblioteca.php"><i class="fas fa-layer-group"></i> Biblioteca</a></li>
            <li><a href="perfil.php"><i class="fas fa-user"></i> Perfil</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Sair</a></li>
        </ul>
    </div>
    
    <div class="main-content">
        <div class="top-menu">
            <div class="page-title">
                <i class="fas fa-palette"></i> Gerenciar Temas para Jogos
            </div>
        </div>
        
        <div class="container">
            <?php if ($message): ?>
                <div class="message"><?php echo $message; ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="themes-grid">
                    <?php foreach ($games_themes as $key => $theme): ?>
                        <div class="theme-card">
                            <div class="theme-preview" style="background: <?php echo $theme['bg_color']; ?>">
                                <i class="fas fa-futbol"></i>
                            </div>
                            
                            <input type="hidden" name="themes[<?php echo $key; ?>][key]" value="<?php echo $key; ?>">
                            
                            <div class="form-group">
                                <label>Nome do Tema</label>
                                <input type="text" name="themes[<?php echo $key; ?>][name]" value="<?php echo $theme['name']; ?>" required>
                            </div>
                            
                            <div class="form-group">
                                <label>Cor de Fundo (hex)</label>
                                <input type="color" name="themes[<?php echo $key; ?>][bg_color]" value="<?php echo $theme['bg_color']; ?>">
                                <input type="text" name="themes[<?php echo $key; ?>][bg_color]" value="<?php echo $theme['bg_color']; ?>" style="margin-top: 5px;">
                            </div>
                            
                            <div class="form-group">
                                <label>Descrição</label>
                                <input type="text" name="themes[<?php echo $key; ?>][description]" value="<?php echo $theme['description']; ?>">
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                
                <button type="submit" name="save_themes" class="btn" style="margin-top: 30px;">
                    <i class="fas fa-save"></i> Salvar Alterações
                </button>
            </form>
        </div>
    </div>
</body>
</html>