<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$message = '';
$error = '';

// Processar upload de imagem de perfil
if (isset($_POST['upload_profile'])) {
    if ($_FILES['profile_image']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['profile_image']['name'], PATHINFO_EXTENSION);
        if (in_array(strtolower($ext), ['png', 'jpg', 'jpeg', 'gif'])) {
            // Remover imagem anterior se existir
            $old_images = glob(PROFILES_DIR . '*.{png,jpg,jpeg,gif}', GLOB_BRACE);
            foreach ($old_images as $old) {
                unlink($old);
            }
            
            $filename = 'profile_' . uniqid() . '.' . $ext;
            move_uploaded_file($_FILES['profile_image']['tmp_name'], PROFILES_DIR . $filename);
            $message = 'Foto de perfil atualizada com sucesso!';
        } else {
            $error = 'Formato não permitido! Use PNG, JPG ou GIF.';
        }
    }
}

// Processar alteração de senha
if (isset($_POST['change_password'])) {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];
    
    if (password_verify($current_password, ADMIN_PASS)) {
        if ($new_password === $confirm_password) {
            // Aqui você poderia salvar a nova senha em um arquivo ou banco de dados
            // Por enquanto, apenas mostramos uma mensagem
            $message = 'Senha alterada com sucesso!';
        } else {
            $error = 'As senhas não conferem!';
        }
    } else {
        $error = 'Senha atual incorreta!';
    }
}

$profile_image = glob(PROFILES_DIR . '*.{png,jpg,jpeg,gif}', GLOB_BRACE);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Perfil - VOD Generator</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f5f5;
            display: flex;
        }
        
        .sidebar {
            width: 250px;
            background: <?php echo COLOR_METALIC; ?>;
            color: white;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            overflow-y: auto;
        }
        
        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h3 {
            color: <?php echo COLOR_NEON; ?>;
            margin-top: 10px;
        }
        
        .menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .menu li {
            padding: 10px 20px;
            transition: background 0.3s;
        }
        
        .menu li:hover {
            background: rgba(0,255,255,0.1);
        }
        
        .menu li.active {
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
        }
        
        .menu li a {
            color: white;
            text-decoration: none;
            display: block;
        }
        
        .menu li i {
            margin-right: 10px;
            width: 20px;
        }
        
        .main-content {
            margin-left: 250px;
            flex: 1;
            padding: 20px;
        }
        
        .top-menu {
            background: white;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .page-title {
            color: <?php echo COLOR_METALIC; ?>;
            font-size: 24px;
            font-weight: bold;
        }
        
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .profile-section {
            display: grid;
            grid-template-columns: 1fr 2fr;
            gap: 30px;
            margin-bottom: 40px;
            padding-bottom: 40px;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .profile-image-section {
            text-align: center;
        }
        
        .profile-image {
            width: 200px;
            height: 200px;
            border-radius: 50%;
            border: 5px solid <?php echo COLOR_NEON; ?>;
            object-fit: cover;
            margin: 0 auto 20px;
            display: block;
        }
        
        .profile-placeholder {
            width: 200px;
            height: 200px;
            border-radius: 50%;
            border: 5px solid <?php echo COLOR_NEON; ?>;
            margin: 0 auto 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #f0f0f0;
        }
        
        .profile-placeholder i {
            font-size: 80px;
            color: #999;
        }
        
        .profile-info h3 {
            color: <?php echo COLOR_METALIC; ?>;
            margin-bottom: 10px;
        }
        
        .profile-info p {
            color: #666;
            margin-bottom: 5px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #666;
            font-weight: 500;
        }
        
        .form-group input {
            width: 100%;
            padding: 10px;
            border: 2px solid #e0e0e0;
            border-radius: 5px;
            font-size: 14px;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: <?php echo COLOR_NEON; ?>;
        }
        
        .btn {
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.3s;
        }
        
        .btn:hover {
            transform: scale(1.05);
        }
        
        .btn-secondary {
            background: <?php echo COLOR_METALIC; ?>;
            color: white;
        }
        
        .message {
            padding: 15px;
            background: #d4edda;
            color: #155724;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .error {
            padding: 15px;
            background: #f8d7da;
            color: #721c24;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .section-title {
            color: <?php echo COLOR_METALIC; ?>;
            font-size: 20px;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid <?php echo COLOR_NEON; ?>;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="sidebar-header">
            <i class="fas fa-film" style="font-size: 40px; color: <?php echo COLOR_NEON; ?>;"></i>
            <h3>VOD Generator</h3>
        </div>
        
        <ul class="menu">
            <li><a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a></li>
            <li><a href="gerar_banners.php"><i class="fas fa-plus-circle"></i> Gerar Banners</a></li>
            <li><a href="gerar_cards.php"><i class="fas fa-image"></i> Gerar Cards</a></li>
            <li><a href="gerar_jogos.php"><i class="fas fa-futbol"></i> Cards Jogos</a></li>
            <li><a href="temas_vod.php"><i class="fas fa-palette"></i> Temas VOD</a></li>
            <li><a href="temas_jogos.php"><i class="fas fa-palette"></i> Temas Jogos</a></li>
            <li><a href="biblioteca.php"><i class="fas fa-layer-group"></i> Biblioteca</a></li>
            <li class="active"><a href="perfil.php"><i class="fas fa-user"></i> Perfil</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Sair</a></li>
        </ul>
    </div>
    
    <div class="main-content">
        <div class="top-menu">
            <div class="page-title">
                <i class="fas fa-user"></i> Meu Perfil
            </div>
        </div>
        
        <div class="container">
            <?php if ($message): ?>
                <div class="message"><?php echo $message; ?></div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="error"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <!-- Seção de Perfil -->
            <div class="profile-section">
                <div class="profile-image-section">
                    <?php if (!empty($profile_image)): ?>
                        <img src="<?php echo str_replace(__DIR__, '', $profile_image[0]); ?>" class="profile-image">
                    <?php else: ?>
                        <div class="profile-placeholder">
                            <i class="fas fa-user-circle"></i>
                        </div>
                    <?php endif; ?>
                    
                    <form method="POST" enctype="multipart/form-data">
                        <input type="file" name="profile_image" accept="image/*" required>
                        <button type="submit" name="upload_profile" class="btn" style="margin-top: 10px; width: 100%;">
                            <i class="fas fa-upload"></i> Atualizar Foto
                        </button>
                    </form>
                </div>
                
                <div class="profile-info">
                    <h3><?php echo $_SESSION['admin_username']; ?></h3>
                    <p><strong>Cargo:</strong> Administrador</p>
                    <p><strong>Email:</strong> <?php echo ADMIN_EMAIL; ?></p>
                    <p><strong>Site:</strong> <?php echo SITE_NAME; ?></p>
                    <p><strong>Data de Acesso:</strong> <?php echo date('d/m/Y H:i:s'); ?></p>
                </div>
            </div>
            
            <!-- Seção de Alteração de Senha -->
            <div class="section-title">
                <i class="fas fa-lock"></i> Alterar Senha
            </div>
            
            <form method="POST" style="max-width: 500px;">
                <div class="form-group">
                    <label>Senha Atual</label>
                    <input type="password" name="current_password" required>
                </div>
                
                <div class="form-group">
                    <label>Nova Senha</label>
                    <input type="password" name="new_password" required>
                </div>
                
                <div class="form-group">
                    <label>Confirmar Nova Senha</label>
                    <input type="password" name="confirm_password" required>
                </div>
                
                <button type="submit" name="change_password" class="btn">
                    <i class="fas fa-save"></i> Alterar Senha
                </button>
            </form>
            
            <!-- Informações do Sistema -->
            <div class="section-title" style="margin-top: 40px;">
                <i class="fas fa-info-circle"></i> Informações do Sistema
            </div>
            
            <div style="background: #f8f9fa; padding: 20px; border-radius: 10px;">
                <p><strong>PHP Version:</strong> <?php echo phpversion(); ?></p>
                <p><strong>Servidor:</strong> <?php echo $_SERVER['SERVER_SOFTWARE']; ?></p>
                <p><strong>Diretório Raiz:</strong> <?php echo ROOT_PATH; ?></p>
                <p><strong>Espaço em Disco:</strong> <?php echo round(disk_free_space(ROOT_PATH) / 1024 / 1024 / 1024, 2); ?> GB disponível</p>
                <p><strong>Versão do VOD Generator:</strong> 1.0.0</p>
            </div>
        </div>
    </div>
</body>
</html>
