<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$games_themes = readJSON(GAMES_THEMES_FILE);
$message = '';
$error = '';

// Buscar jogos da API
if (isset($_POST['fetch_games'])) {
    $games_data = fetchGamesFromAPI();
    
    if (!empty($games_data)) {
        // Processar cada jogo
        foreach ($games_data as &$game) {
            // Baixar imagens dos times
            if (!empty($game['img_time1_url'])) {
                $ext = 'png';
                $filename = 'team1_' . uniqid() . '.' . $ext;
                $downloaded = downloadGameImage($game['img_time1_url'], $filename);
                $game['img_time1'] = $downloaded ? $filename : '';
            }
            
            if (!empty($game['img_time2_url'])) {
                $ext = 'png';
                $filename = 'team2_' . uniqid() . '.' . $ext;
                $downloaded = downloadGameImage($game['img_time2_url'], $filename);
                $game['img_time2'] = $downloaded ? $filename : '';
            }
            
            // Baixar imagens dos canais
            if (!empty($game['canais'])) {
                foreach ($game['canais'] as &$canal) {
                    if (!empty($canal['img_url'])) {
                        $ext = 'png';
                        $filename = 'canal_' . uniqid() . '.' . $ext;
                        $downloaded = downloadGameImage($canal['img_url'], $filename);
                        $canal['img'] = $downloaded ? $filename : '';
                    }
                }
            }
        }
        
        // Salvar dados dos jogos
        writeJSON(GAMES_FILE, $games_data);
        $message = 'Jogos atualizados com sucesso!';
    } else {
        $error = 'Erro ao buscar jogos da API';
    }
}

// Gerar card para jogo específico
if (isset($_POST['generate_game_card'])) {
    $games = readJSON(GAMES_FILE);
    $game_index = $_POST['game_index'];
    $theme = $_POST['theme'];
    
    if (isset($games[$game_index])) {
        $card_file = generateGameCard($games[$game_index], $theme);
        
        // Salvar no histórico
        $generated_cards = readJSON(GAMES_CARDS_DIR . 'history.json');
        if (!is_array($generated_cards)) $generated_cards = [];
        
        $generated_cards[] = [
            'file' => $card_file,
            'game' => $games[$game_index]['time1'] . ' x ' . $games[$game_index]['time2'],
            'theme' => $theme,
            'date' => date('Y-m-d H:i:s')
        ];
        
        writeJSON(GAMES_CARDS_DIR . 'history.json', $generated_cards);
        $_SESSION['last_game_card'] = $card_file;
        $message = 'Card de jogo gerado com sucesso!';
    }
}

// Gerar card com todos os jogos
if (isset($_POST['generate_all_games_card'])) {
    $games = readJSON(GAMES_FILE);
    $theme = $_POST['theme_all'] ?? 'tema1';
    
    if (!empty($games)) {
        $card_file = generateAllGamesCard($games, $theme);
        
        // Salvar no histórico
        $generated_cards = readJSON(GAMES_CARDS_DIR . 'history.json');
        if (!is_array($generated_cards)) $generated_cards = [];
        
        $generated_cards[] = [
            'file' => $card_file,
            'game' => 'TODOS OS JOGOS',
            'theme' => $theme,
            'date' => date('Y-m-d H:i:s')
        ];
        
        writeJSON(GAMES_CARDS_DIR . 'history.json', $generated_cards);
        $_SESSION['last_game_card'] = $card_file;
        $message = 'Card com todos os jogos gerado com sucesso!';
    } else {
        $error = 'Não há jogos disponíveis para gerar o card.';
    }
}

$games = readJSON(GAMES_FILE);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerar Cards de Jogos - VOD Generator</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f5f5;
            display: flex;
        }
        
        .sidebar {
            width: 250px;
            background: <?php echo COLOR_METALIC; ?>;
            color: white;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            overflow-y: auto;
        }
        
        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h3 {
            color: <?php echo COLOR_NEON; ?>;
            margin-top: 10px;
        }
        
        .menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .menu li {
            padding: 10px 20px;
            transition: background 0.3s;
        }
        
        .menu li:hover {
            background: rgba(0,255,255,0.1);
        }
        
        .menu li.active {
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
        }
        
        .menu li a {
            color: white;
            text-decoration: none;
            display: block;
        }
        
        .menu li i {
            margin-right: 10px;
            width: 20px;
        }
        
        .main-content {
            margin-left: 250px;
            flex: 1;
            padding: 20px;
        }
        
        .top-menu {
            background: white;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .page-title {
            color: <?php echo COLOR_METALIC; ?>;
            font-size: 24px;
            font-weight: bold;
        }
        
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .btn {
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.3s;
        }
        
        .btn:hover {
            transform: scale(1.05);
        }
        
        .btn-secondary {
            background: <?php echo COLOR_METALIC; ?>;
            color: white;
        }
        
        .message {
            padding: 15px;
            background: #d4edda;
            color: #155724;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .error {
            padding: 15px;
            background: #f8d7da;
            color: #721c24;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .games-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }
        
        .game-item {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            border: 2px solid #e0e0e0;
            transition: all 0.3s;
        }
        
        .game-item:hover {
            border-color: <?php echo COLOR_NEON; ?>;
            transform: translateY(-5px);
        }
        
        .game-header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .game-competition {
            font-weight: bold;
            color: <?php echo COLOR_METALIC; ?>;
        }
        
        .game-status {
            color: #ff4444;
            font-weight: bold;
        }
        
        .game-teams {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin: 20px 0;
        }
        
        .team {
            text-align: center;
            flex: 1;
        }
        
        .team-logo {
            width: 60px;
            height: 60px;
            object-fit: contain;
            margin-bottom: 10px;
        }
        
        .team-name {
            font-weight: bold;
            font-size: 14px;
        }
        
        .vs {
            font-size: 20px;
            font-weight: bold;
            color: <?php echo COLOR_NEON; ?>;
            margin: 0 20px;
        }
        
        .game-time {
            text-align: center;
            margin: 15px 0;
            color: #666;
        }
        
        .channels {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
            margin: 15px 0;
        }
        
        .channel {
            background: <?php echo COLOR_METALIC; ?>;
            color: white;
            padding: 5px 10px;
            border-radius: 5px;
            font-size: 12px;
        }
        
        .theme-selector {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 10px;
            margin: 20px 0;
            max-height: 300px;
            overflow-y: auto;
        }
        
        .theme-item {
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            padding: 10px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .theme-item:hover {
            border-color: <?php echo COLOR_NEON; ?>;
        }
        
        .theme-item.selected {
            border-color: <?php echo COLOR_NEON; ?>;
            background: rgba(0,255,255,0.1);
        }
        
        .theme-color {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            margin: 0 auto 10px;
        }
        
        .card-preview {
            max-width: 600px;
            margin: 20px auto;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 20px rgba(0,0,0,0.2);
        }
        
        .card-preview img {
            width: 100%;
            height: auto;
        }
        
        .fetch-section {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .game-count {
            color: #666;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="sidebar-header">
            <i class="fas fa-film" style="font-size: 40px; color: <?php echo COLOR_NEON; ?>;"></i>
            <h3>VOD Cards</h3>
        </div>
        
        <ul class="menu">
            <li><a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a></li>
            <li><a href="gerar_cards.php"><i class="fas fa-plus-circle"></i> Cards VOD</a></li>
            <li class="active"><a href="gerar_jogos.php"><i class="fas fa-futbol"></i> Cards Jogos</a></li>
            <li><a href="temas_vod.php"><i class="fas fa-palette"></i> Temas VOD</a></li>
            <li><a href="temas_jogos.php"><i class="fas fa-palette"></i> Temas Jogos</a></li>
            <li><a href="biblioteca.php"><i class="fas fa-layer-group"></i> Biblioteca</a></li>
            <li><a href="perfil.php"><i class="fas fa-user"></i> Perfil</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Sair</a></li>
        </ul>
    </div>
    
    <div class="main-content">
        <div class="top-menu">
            <div class="page-title">
                <i class="fas fa-futbol"></i> Gerar Cards de Jogos
            </div>
        </div>
        
        <div class="container">
            <?php if ($message): ?>
                <div class="message"><?php echo $message; ?></div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="error"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <div class="fetch-section">
                <div>
                    <h3>Jogos do Dia</h3>
                    <p class="game-count">Total: <?php echo count($games); ?> jogos</p>
                </div>
                
                <div style="display: flex; gap: 10px;">
                    <form method="POST">
                        <button type="submit" name="fetch_games" class="btn">
                            <i class="fas fa-sync"></i> Buscar Jogos Agora
                        </button>
                    </form>
                    
                    <?php if (!empty($games)): ?>
                    <button class="btn btn-secondary" onclick="document.getElementById('all-games-theme-selector').style.display = 'block'">
                        <i class="fas fa-layer-group"></i> Gerar Card com Todos os Jogos
                    </button>
                    <?php endif; ?>
                </div>
            </div>

            <?php if (!empty($games)): ?>
                <div id="all-games-theme-selector" style="display: none; margin-bottom: 30px; padding: 20px; background: #f0f0f0; border-radius: 10px; border: 2px solid <?php echo COLOR_NEON; ?>;">
                    <h3>Escolha o Tema para Todos os Jogos:</h3>
                    <div class="theme-selector">
                        <?php foreach ($games_themes as $key => $theme): ?>
                            <div class="theme-item" onclick="selectThemeAll('<?php echo $key; ?>')">
                                <div class="theme-color" style="background: <?php echo $theme['bg_color']; ?>"></div>
                                <div class="theme-name"><?php echo $theme['name']; ?></div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <form method="POST">
                        <input type="hidden" name="theme_all" id="theme_all_input" value="tema1">
                        <button type="submit" name="generate_all_games_card" class="btn" style="width: 100%;">
                            <i class="fas fa-check-circle"></i> Gerar Card Único
                        </button>
                    </form>
                </div>
            <?php endif; ?>
            
            <?php if (!empty($games)): ?>
                <h3 style="margin: 20px 0;">Selecione um jogo para gerar card</h3>
                
                <div class="games-grid">
                    <?php foreach ($games as $index => $game): ?>
                        <div class="game-item">
                            <div class="game-header">
                                <span class="game-competition"><?php echo $game['competicao']; ?></span>
                                <?php if (!empty($game['status'])): ?>
                                    <span class="game-status"><?php echo $game['status']; ?></span>
                                <?php endif; ?>
                            </div>
                            
                            <div class="game-teams">
                                <div class="team">
                                    <?php if (!empty($game['img_time1']) && file_exists(GAMES_IMAGES_DIR . $game['img_time1'])): ?>
                                        <img src="<?php echo str_replace(ROOT_PATH, '', GAMES_IMAGES_DIR) . $game['img_time1']; ?>" class="team-logo">
                                    <?php else: ?>
                                        <div style="width: 60px; height: 60px; background: #ddd; border-radius: 50%; margin: 0 auto;"></div>
                                    <?php endif; ?>
                                    <div class="team-name"><?php echo $game['time1']; ?></div>
                                </div>
                                
                                <div class="vs">VS</div>
                                
                                <div class="team">
                                    <?php if (!empty($game['img_time2']) && file_exists(GAMES_IMAGES_DIR . $game['img_time2'])): ?>
                                        <img src="<?php echo str_replace(ROOT_PATH, '', GAMES_IMAGES_DIR) . $game['img_time2']; ?>" class="team-logo">
                                    <?php else: ?>
                                        <div style="width: 60px; height: 60px; background: #ddd; border-radius: 50%; margin: 0 auto;"></div>
                                    <?php endif; ?>
                                    <div class="team-name"><?php echo $game['time2']; ?></div>
                                </div>
                            </div>
                            
                            <div class="game-time">
                                <i class="far fa-clock"></i> <?php echo $game['horario']; ?> - <?php echo ucfirst($game['data_jogo']); ?>
                            </div>
                            
                            <div class="channels">
                                <?php foreach ($game['canais'] as $canal): ?>
                                    <span class="channel"><?php echo $canal['nome']; ?></span>
                                <?php endforeach; ?>
                            </div>
                            
                            <button class="btn btn-secondary" style="width: 100%; margin-top: 10px;" onclick="showThemeSelector(<?php echo $index; ?>)">
                                <i class="fas fa-magic"></i> Gerar Card
                            </button>
                            
                            <div id="theme-selector-<?php echo $index; ?>" style="display: none; margin-top: 20px;">
                                <h4>Escolha o Tema:</h4>
                                <div class="theme-selector">
                                    <?php foreach ($games_themes as $key => $theme): ?>
                                        <div class="theme-item" onclick="selectTheme('<?php echo $key; ?>', <?php echo $index; ?>)">
                                            <div class="theme-color" style="background: <?php echo $theme['bg_color']; ?>"></div>
                                            <div class="theme-name"><?php echo $theme['name']; ?></div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                
                                <form method="POST" id="game-form-<?php echo $index; ?>">
                                    <input type="hidden" name="game_index" value="<?php echo $index; ?>">
                                    <input type="hidden" name="theme" id="theme-<?php echo $index; ?>" value="tema1">
                                    <button type="submit" name="generate_game_card" class="btn" style="width: 100%; margin-top: 10px;">
                                        Gerar Agora
                                    </button>
                                </form>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            
            <!-- Last Generated Card -->
            <?php if (isset($_SESSION['last_game_card']) && file_exists(GAMES_CARDS_DIR . $_SESSION['last_game_card'])): ?>
                <div style="margin-top: 40px;">
                    <h3>Último Card Gerado</h3>
                    <div class="card-preview">
                        <img src="<?php echo str_replace(ROOT_PATH, '', GAMES_CARDS_DIR) . $_SESSION['last_game_card']; ?>">
                    </div>
                    <a href="<?php echo str_replace(ROOT_PATH, '', GAMES_CARDS_DIR) . $_SESSION['last_game_card']; ?>" download class="btn" style="display: inline-block;">
                        <i class="fas fa-download"></i> Baixar Card
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
        function showThemeSelector(index) {
            document.getElementById('theme-selector-' + index).style.display = 'block';
        }
        
        function selectTheme(theme, index) {
            document.getElementById('theme-' + index).value = theme;
            
            // Visual feedback
            document.querySelectorAll('#theme-selector-' + index + ' .theme-item').forEach(item => {
                item.classList.remove('selected');
            });
            event.currentTarget.classList.add('selected');
        }

        function selectThemeAll(theme) {
            document.getElementById('theme_all_input').value = theme;
            
            // Visual feedback
            document.querySelectorAll('#all-games-theme-selector .theme-item').forEach(item => {
                item.classList.remove('selected');
            });
            event.currentTarget.classList.add('selected');
        }
    </script>
</body>
</html>