<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$themes = readJSON(THEMES_VOD_FILE);
$settings = readJSON(SETTINGS_FILE);
$message = '';
$error = '';
$search_results = [];

// Processar busca TMDB
if (isset($_POST['search_tmdb'])) {
    $search = $_POST['search'];
    $type = $_POST['type'];
    $search_results = searchTMDB($search, $type);
}

// Processar seleção de filme/série
if (isset($_POST['select_item'])) {
    $id = $_POST['id'];
    $type = $_POST['type'];
    
    $details = getTMDBDetails($id, $type);
    
    if ($details) {
        // Processar elenco
        $cast = [];
        if (isset($details['credits']['cast'])) {
            foreach (array_slice($details['credits']['cast'], 0, 8) as $actor) {
                $cast[] = $actor['name'];
            }
        }
        
        // Processar gêneros
        $genres = [];
        if (isset($details['genres'])) {
            foreach ($details['genres'] as $genre) {
                $genres[] = $genre['name'];
            }
        }
        
        // Salvar dados para o card
        $card_data = [
            'id' => $id,
            'type' => $type,
            'title' => $details['title'] ?? $details['name'] ?? '',
            'original_title' => $details['original_title'] ?? $details['original_name'] ?? '',
            'overview' => $details['overview'] ?? '',
            'year' => substr($details['release_date'] ?? $details['first_air_date'] ?? '', 0, 4),
            'vote_average' => $details['vote_average'] ?? 0,
            'runtime' => $details['runtime'] ?? ($details['episode_run_time'][0] ?? ''),
            'genres' => $genres,
            'cast' => $cast
        ];
        
        $_SESSION['current_card'] = $card_data;
    }
}

// Processar geração do card
if (isset($_POST['generate_card']) && isset($_SESSION['current_card'])) {
    $card_data = $_SESSION['current_card'];
    $card_data['theme'] = $_POST['theme'];
    $card_data['site_logo'] = $settings['logo'] ?? '';
    
    $card_file = generateVODCard($card_data);
    
    // Salvar no histórico
    $cards = readJSON(CARDS_FILE);
    if (!is_array($cards)) $cards = [];
    
    $cards[] = [
        'file' => $card_file,
        'title' => $card_data['title'],
        'theme' => $_POST['theme'],
        'date' => date('Y-m-d H:i:s')
    ];
    writeJSON(CARDS_FILE, $cards);
    
    $message = 'Card gerado com sucesso!';
    $_SESSION['last_card'] = $card_file;
}

// Upload da logo do site
if (isset($_POST['upload_logo'])) {
    if ($_FILES['logo']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
        if (in_array(strtolower($ext), ['png', 'jpg', 'jpeg', 'gif'])) {
            $filename = 'site_logo_' . uniqid() . '.' . $ext;
            move_uploaded_file($_FILES['logo']['tmp_name'], LOGOS_DIR . $filename);
            
            $settings['logo'] = $filename;
            writeJSON(SETTINGS_FILE, $settings);
            
            $message = 'Logo do site enviada com sucesso!';
        } else {
            $error = 'Formato não permitido! Use PNG, JPG ou GIF.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerar Cards VOD - VOD Generator</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f5f5;
            display: flex;
        }
        
        .sidebar {
            width: 250px;
            background: <?php echo COLOR_METALIC; ?>;
            color: white;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            overflow-y: auto;
        }
        
        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h3 {
            color: <?php echo COLOR_NEON; ?>;
            margin-top: 10px;
        }
        
        .menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .menu li {
            padding: 10px 20px;
            transition: background 0.3s;
        }
        
        .menu li:hover {
            background: rgba(0,255,255,0.1);
        }
        
        .menu li.active {
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
        }
        
        .menu li a {
            color: white;
            text-decoration: none;
            display: block;
        }
        
        .menu li i {
            margin-right: 10px;
            width: 20px;
        }
        
        .main-content {
            margin-left: 250px;
            flex: 1;
            padding: 20px;
        }
        
        .top-menu {
            background: white;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .page-title {
            color: <?php echo COLOR_METALIC; ?>;
            font-size: 24px;
            font-weight: bold;
        }
        
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .search-section {
            margin-bottom: 30px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 10px;
        }
        
        .search-form {
            display: flex;
            gap: 10px;
            align-items: flex-end;
        }
        
        .form-group {
            flex: 1;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #666;
            font-weight: 500;
        }
        
        .form-group input,
        .form-group select {
            width: 100%;
            padding: 10px;
            border: 2px solid #e0e0e0;
            border-radius: 5px;
            font-size: 14px;
        }
        
        .form-group input:focus,
        .form-group select:focus {
            outline: none;
            border-color: <?php echo COLOR_NEON; ?>;
        }
        
        .btn {
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.3s;
        }
        
        .btn:hover {
            transform: scale(1.05);
        }
        
        .btn-secondary {
            background: <?php echo COLOR_METALIC; ?>;
            color: white;
        }
        
        .results-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }
        
        .result-item {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            transition: transform 0.3s;
            cursor: pointer;
        }
        
        .result-item:hover {
            transform: translateY(-5px);
        }
        
        .result-poster {
            width: 100%;
            height: 300px;
            object-fit: cover;
        }
        
        .result-info {
            padding: 15px;
        }
        
        .result-title {
            font-weight: bold;
            margin-bottom: 5px;
            color: <?php echo COLOR_METALIC; ?>;
        }
        
        .result-year {
            color: #666;
            font-size: 14px;
        }
        
        .theme-selector {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 15px;
            margin: 20px 0;
        }
        
        .theme-item {
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            padding: 15px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .theme-item:hover {
            border-color: <?php echo COLOR_NEON; ?>;
        }
        
        .theme-item.selected {
            border-color: <?php echo COLOR_NEON; ?>;
            background: rgba(0,255,255,0.1);
        }
        
        .theme-color {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            margin: 0 auto 10px;
        }
        
        .theme-name {
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .theme-desc {
            font-size: 12px;
            color: #666;
        }
        
        .preview-section {
            margin-top: 30px;
            text-align: center;
        }
        
        .card-preview {
            max-width: 500px;
            margin: 20px auto;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 20px rgba(0,0,0,0.2);
        }
        
        .card-preview img {
            width: 100%;
            height: auto;
        }
        
        .message {
            padding: 15px;
            background: #d4edda;
            color: #155724;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .error {
            padding: 15px;
            background: #f8d7da;
            color: #721c24;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .logo-upload {
            display: flex;
            align-items: center;
            gap: 20px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .current-logo {
            width: 100px;
            height: 100px;
            object-fit: contain;
            border: 2px solid <?php echo COLOR_NEON; ?>;
            border-radius: 10px;
            padding: 5px;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="sidebar-header">
            <i class="fas fa-film" style="font-size: 40px; color: <?php echo COLOR_NEON; ?>;"></i>
            <h3>VOD Generator</h3>
        </div>
        
        <ul class="menu">
            <li><a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a></li>
            <li><a href="gerar_banners.php"><i class="fas fa-plus-circle"></i> Gerar Banners</a></li>
            <li class="active"><a href="gerar_cards.php"><i class="fas fa-image"></i> Gerar Cards</a></li>
            <li><a href="gerar_jogos.php"><i class="fas fa-futbol"></i> Cards Jogos</a></li>
            <li><a href="temas_vod.php"><i class="fas fa-palette"></i> Temas VOD</a></li>
            <li><a href="temas_jogos.php"><i class="fas fa-palette"></i> Temas Jogos</a></li>
            <li><a href="biblioteca.php"><i class="fas fa-layer-group"></i> Biblioteca</a></li>
            <li><a href="perfil.php"><i class="fas fa-user"></i> Perfil</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Sair</a></li>
        </ul>
    </div>
    
    <div class="main-content">
        <div class="top-menu">
            <div class="page-title">
                <i class="fas fa-plus-circle"></i> Gerar Novo Card VOD
            </div>
        </div>
        
        <div class="container">
            <?php if ($message): ?>
                <div class="message"><?php echo $message; ?></div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="error"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <!-- Logo Upload -->
            <div class="logo-upload">
                <?php if (!empty($settings['logo']) && file_exists(LOGOS_DIR . $settings['logo'])): ?>
                    <img src="<?php echo str_replace(ROOT_PATH, '', LOGOS_DIR) . $settings['logo']; ?>" class="current-logo">
                <?php else: ?>
                    <div style="width: 100px; height: 100px; background: #f0f0f0; border-radius: 10px; display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-image" style="font-size: 40px; color: #999;"></i>
                    </div>
                <?php endif; ?>
                
                <form method="POST" enctype="multipart/form-data" style="flex: 1;">
                    <h3>Logo do Site</h3>
                    <p style="color: #666; margin-bottom: 10px;">Faça upload da logo que aparecerá nos cards</p>
                    <input type="file" name="logo" accept="image/*" required>
                    <button type="submit" name="upload_logo" class="btn" style="margin-top: 10px;">Upload Logo</button>
                </form>
            </div>
            
            <!-- Search Form -->
            <div class="search-section">
                <h3 style="margin-bottom: 20px;">Buscar no TMDB</h3>
                <form method="POST" class="search-form">
                    <div class="form-group">
                        <label>Buscar</label>
                        <input type="text" name="search" placeholder="Digite o nome do filme ou série..." required>
                    </div>
                    <div class="form-group">
                        <label>Tipo</label>
                        <select name="type">
                            <option value="movie">Filme</option>
                            <option value="tv">Série</option>
                        </select>
                    </div>
                    <button type="submit" name="search_tmdb" class="btn">Buscar</button>
                </form>
            </div>
            
            <!-- Search Results -->
            <?php if (!empty($search_results['results'])): ?>
                <h3 style="margin: 20px 0;">Resultados da Busca</h3>
                <div class="results-grid">
                    <?php foreach ($search_results['results'] as $item): ?>
                        <div class="result-item" onclick="selectItem('<?php echo $item['id']; ?>', '<?php echo $_POST['type']; ?>')">
                            <?php if (!empty($item['poster_path'])): ?>
                                <img src="https://image.tmdb.org/t/p/w200<?php echo $item['poster_path']; ?>" class="result-poster">
                            <?php else: ?>
                                <div style="height: 300px; background: #f0f0f0; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-film" style="font-size: 50px; color: #999;"></i>
                                </div>
                            <?php endif; ?>
                            <div class="result-info">
                                <div class="result-title"><?php echo $item['title'] ?? $item['name']; ?></div>
                                <div class="result-year">
                                    <?php 
                                    $date = $item['release_date'] ?? $item['first_air_date'] ?? '';
                                    echo substr($date, 0, 4);
                                    ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                
                <form method="POST" id="selectForm" style="display: none;">
                    <input type="hidden" name="id" id="selectedId">
                    <input type="hidden" name="type" id="selectedType">
                    <input type="hidden" name="select_item" value="1">
                </form>
            <?php endif; ?>
            
            <!-- Card Preview and Theme Selection -->
            <?php if (isset($_SESSION['current_card'])): ?>
                <div class="preview-section">
                    <h3 style="color: <?php echo COLOR_METALIC; ?>; margin-bottom: 20px;">Selecione um Tema</h3>
                    
                    <form method="POST">
                        <div class="theme-selector">
                            <?php foreach ($themes as $key => $theme): ?>
                                <div class="theme-item" onclick="selectTheme('<?php echo $key; ?>')">
                                    <div class="theme-color" style="background: <?php echo $theme['bg_color']; ?>;"></div>
                                    <div class="theme-name"><?php echo $theme['name']; ?></div>
                                    <div class="theme-desc"><?php echo $theme['description']; ?></div>
                                    <input type="radio" name="theme" value="<?php echo $key; ?>" style="display: none;" id="theme_<?php echo $key; ?>">
                                </div>
                            <?php endforeach; ?>
                        </div>
                        
                        <button type="submit" name="generate_card" class="btn" style="margin-top: 20px;">
                            <i class="fas fa-magic"></i> Gerar Card
                        </button>
                    </form>
                </div>
            <?php endif; ?>
            
            <!-- Last Generated Card -->
            <?php if (isset($_SESSION['last_card']) && file_exists(CARDS_DIR . $_SESSION['last_card'])): ?>
                <div class="preview-section">
                    <h3 style="color: <?php echo COLOR_METALIC; ?>;">Último Card Gerado</h3>
                    <div class="card-preview">
                        <img src="<?php echo str_replace(ROOT_PATH, '', CARDS_DIR) . $_SESSION['last_card']; ?>" alt="Card Preview">
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
        function selectItem(id, type) {
            document.getElementById('selectedId').value = id;
            document.getElementById('selectedType').value = type;
            document.getElementById('selectForm').submit();
        }
        
        function selectTheme(key) {
            document.getElementById('theme_' + key).checked = true;
            document.querySelectorAll('.theme-item').forEach(item => item.classList.remove('selected'));
            event.target.closest('.theme-item').classList.add('selected');
        }
    </script>
</body>
</html>
