<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$themes = readJSON(THEMES_FILE);
$message = '';
$error = '';

// Processar formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['search_tmdb'])) {
        $search = $_POST['search'];
        $type = $_POST['type'];
        $results = searchTMDB($search, $type);
    } elseif (isset($_POST['generate_banner'])) {
        $data = [
            'title' => $_POST['title'],
            'type' => $_POST['type'],
            'theme' => $_POST['theme'],
            'year' => $_POST['year'],
            'rating' => $_POST['rating'],
            'logo' => $_POST['logo'] ?? ''
        ];
        
        $banner_file = generateBanner($data);
        $message = 'Banner gerado com sucesso!';
    } elseif (isset($_POST['upload_logo'])) {
        if ($_FILES['logo']['error'] === UPLOAD_ERR_OK) {
            $ext = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
            if (in_array(strtolower($ext), ALLOWED_EXTENSIONS)) {
                $filename = 'logo_' . uniqid() . '.' . $ext;
                move_uploaded_file($_FILES['logo']['tmp_name'], LOGOS_DIR . $filename);
                
                // Salvar no settings
                $settings = readJSON(SETTINGS_FILE);
                $settings['logo'] = $filename;
                writeJSON(SETTINGS_FILE, $settings);
                
                $message = 'Logo enviado com sucesso!';
            } else {
                $error = 'Formato de arquivo não permitido!';
            }
        }
    }
}

$settings = readJSON(SETTINGS_FILE);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerar Banners - VOD Generator</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f5f5;
            display: flex;
        }
        
        .sidebar {
            width: 250px;
            background: <?php echo COLOR_METALIC; ?>;
            color: white;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            overflow-y: auto;
        }
        
        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h3 {
            color: <?php echo COLOR_NEON; ?>;
            margin-top: 10px;
        }
        
        .menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .menu li {
            padding: 10px 20px;
            transition: background 0.3s;
        }
        
        .menu li:hover {
            background: rgba(0,255,255,0.1);
        }
        
        .menu li.active {
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
        }
        
        .menu li a {
            color: white;
            text-decoration: none;
            display: block;
        }
        
        .menu li i {
            margin-right: 10px;
            width: 20px;
        }
        
        .main-content {
            margin-left: 250px;
            flex: 1;
            padding: 20px;
        }
        
        .top-menu {
            background: white;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .search-box {
            display: flex;
            align-items: center;
            background: #f5f5f5;
            padding: 8px 15px;
            border-radius: 25px;
            width: 400px;
        }
        
        .search-box i {
            color: #999;
            margin-right: 10px;
        }
        
        .search-box input {
            border: none;
            background: transparent;
            outline: none;
            width: 100%;
            font-size: 14px;
        }
        
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        h2 {
            color: <?php echo COLOR_METALIC; ?>;
            margin-bottom: 20px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #666;
            font-weight: 500;
        }
        
        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 10px;
            border: 2px solid #e0e0e0;
            border-radius: 5px;
            font-size: 14px;
            transition: border-color 0.3s;
        }
        
        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: <?php echo COLOR_NEON; ?>;
        }
        
        .btn {
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.3s;
        }
        
        .btn:hover {
            transform: scale(1.05);
        }
        
        .btn-secondary {
            background: <?php echo COLOR_METALIC; ?>;
            color: white;
        }
        
        .message {
            padding: 10px;
            background: #d4ed