<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

// Estatísticas
$movies = readJSON(MOVIES_FILE);
$series = readJSON(SERIES_FILE);
$banners = glob(BANNERS_DIR . '*.{png,jpg,jpeg}', GLOB_BRACE) ?: [];
$cards = readJSON(CARDS_FILE);
$games = readJSON(GAMES_FILE);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - VOD Generator</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f5f5;
            display: flex;
        }
        
        /* Menu Lateral */
        .sidebar {
            width: 250px;
            background: <?php echo COLOR_METALIC; ?>;
            color: white;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            overflow-y: auto;
        }
        
        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h3 {
            color: <?php echo COLOR_NEON; ?>;
            margin-top: 10px;
        }
        
        .profile-info {
            text-align: center;
            padding: 20px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .profile-image {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            border: 3px solid <?php echo COLOR_NEON; ?>;
            margin-bottom: 10px;
        }
        
        .menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .menu li {
            padding: 10px 20px;
            transition: background 0.3s;
        }
        
        .menu li:hover {
            background: rgba(0,255,255,0.1);
        }
        
        .menu li.active {
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
        }
        
        .menu li a {
            color: white;
            text-decoration: none;
            display: block;
        }
        
        .menu li i {
            margin-right: 10px;
            width: 20px;
        }
        
        /* Conteúdo Principal */
        .main-content {
            margin-left: 250px;
            flex: 1;
            padding: 20px;
        }
        
        /* Top Menu */
        .top-menu {
            background: white;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .search-box {
            display: flex;
            align-items: center;
            background: #f5f5f5;
            padding: 8px 15px;
            border-radius: 25px;
            width: 400px;
        }
        
        .search-box i {
            color: #999;
            margin-right: 10px;
        }
        
        .search-box input {
            border: none;
            background: transparent;
            outline: none;
            width: 100%;
            font-size: 14px;
        }
        
        .user-menu {
            display: flex;
            align-items: center;
            gap: 20px;
        }
        
        .user-menu i {
            font-size: 20px;
            color: <?php echo COLOR_METALIC; ?>;
            cursor: pointer;
        }
        
        /* Cards */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .stat-info h3 {
            color: #666;
            font-size: 14px;
            margin-bottom: 5px;
        }
        
        .stat-info .number {
            color: <?php echo COLOR_METALIC; ?>;
            font-size: 32px;
            font-weight: bold;
        }
        
        .stat-icon {
            width: 60px;
            height: 60px;
            background: <?php echo COLOR_NEON; ?>;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: <?php echo COLOR_METALIC; ?>;
            font-size: 24px;
        }
        
        /* Banners Recentes */
        .recent-banners {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .banners-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }
        
        .banner-item {
            position: relative;
            border-radius: 5px;
            overflow: hidden;
            cursor: pointer;
        }
        
        .banner-item img {
            width: 100%;
            height: 120px;
            object-fit: cover;
            transition: transform 0.3s;
        }
        
        .banner-item:hover img {
            transform: scale(1.1);
        }
        
        .banner-overlay {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: linear-gradient(transparent, rgba(0,0,0,0.8));
            padding: 10px;
            color: white;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <!-- Menu Lateral -->
    <div class="sidebar">
        <div class="sidebar-header">
            <i class="fas fa-film" style="font-size: 40px; color: <?php echo COLOR_NEON; ?>;"></i>
            <h3>VOD Generator</h3>
        </div>
        
        <div class="profile-info">
            <?php
            $profile_image = glob(PROFILES_DIR . '*.{png,jpg,jpeg}', GLOB_BRACE);
            if (!empty($profile_image)) {
                echo '<img src="' . str_replace(__DIR__, '', $profile_image[0]) . '" class="profile-image">';
            } else {
                echo '<i class="fas fa-user-circle" style="font-size: 80px; color: ' . COLOR_NEON . ';"></i>';
            }
            ?>
            <h4><?php echo $_SESSION['admin_username']; ?></h4>
            <p style="color: <?php echo COLOR_NEON; ?>; font-size: 12px;">Administrador</p>
        </div>
        
        <ul class="menu">
            <li class="active"><a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a></li>
            <li><a href="gerar_banners.php"><i class="fas fa-plus-circle"></i> Gerar Banners</a></li>
            <li><a href="gerar_cards.php"><i class="fas fa-image"></i> Gerar Cards</a></li>
            <li><a href="gerar_jogos.php"><i class="fas fa-futbol"></i> Cards Jogos</a></li>
            <li><a href="temas_vod.php"><i class="fas fa-palette"></i> Temas VOD</a></li>
            <li><a href="temas_jogos.php"><i class="fas fa-palette"></i> Temas Jogos</a></li>
            <li><a href="biblioteca.php"><i class="fas fa-layer-group"></i> Biblioteca</a></li>
            <li><a href="perfil.php"><i class="fas fa-user"></i> Perfil</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Sair</a></li>
        </ul>
    </div>
    
    <!-- Conteúdo Principal -->
    <div class="main-content">
        <!-- Top Menu -->
        <div class="top-menu">
            <div class="search-box">
                <i class="fas fa-search"></i>
                <input type="text" id="searchInput" placeholder="Pesquisar filmes ou séries...">
            </div>
            
            <div class="user-menu">
                <i class="fas fa-bell"></i>
                <i class="fas fa-cog"></i>
            </div>
        </div>
        
        <!-- Stats Cards -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-info">
                    <h3>Filmes</h3>
                    <div class="number"><?php echo count($movies); ?></div>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-film"></i>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-info">
                    <h3>Séries</h3>
                    <div class="number"><?php echo count($series); ?></div>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-tv"></i>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-info">
                    <h3>Banners</h3>
                    <div class="number"><?php echo count($banners); ?></div>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-image"></i>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-info">
                    <h3>Cards VOD</h3>
                    <div class="number"><?php echo count($cards); ?></div>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-layer-group"></i>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-info">
                    <h3>Jogos</h3>
                    <div class="number"><?php echo count($games); ?></div>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-futbol"></i>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-info">
                    <h3>Temas</h3>
                    <div class="number"><?php echo count(readJSON(THEMES_FILE)); ?></div>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-palette"></i>
                </div>
            </div>
        </div>
        
        <!-- Banners Recentes -->
        <div class="recent-banners">
            <h2 style="color: <?php echo COLOR_METALIC; ?>; margin-bottom: 20px;">Banners Recentes</h2>
            
            <div class="banners-grid" id="bannersGrid">
                <?php
                $recent_banners = array_slice($banners, 0, 8);
                if (!empty($recent_banners)) {
                    foreach ($recent_banners as $banner):
                        $banner_url = str_replace(__DIR__, '', $banner);
                        $banner_name = basename($banner);
                    ?>
                    <div class="banner-item" onclick="downloadBanner('<?php echo $banner_url; ?>')">
                        <img src="<?php echo $banner_url; ?>" alt="Banner">
                        <div class="banner-overlay">
                            <i class="fas fa-download"></i> Clique para baixar
                        </div>
                    </div>
                    <?php
                    endforeach;
                } else {
                    echo '<p style="grid-column: 1/-1; text-align: center; color: #999;">Nenhum banner gerado ainda</p>';
                }
                ?>
            </div>
        </div>
    </div>
    
    <script>
        // Função para download de banner
        function downloadBanner(url) {
            const link = document.createElement('a');
            link.href = url;
            link.download = url.split('/').pop();
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
        
        // Pesquisa em tempo real
        document.getElementById('searchInput').addEventListener('keyup', function() {
            const searchTerm = this.value.toLowerCase();
            // Implementar pesquisa via AJAX
        });
    </script>
</body>
</html>
