<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

// Obter todos os cards
$cards = readJSON(CARDS_FILE);
$banners = glob(BANNERS_DIR . '*.{png,jpg,jpeg}', GLOB_BRACE) ?: [];
$games_cards = glob(GAMES_CARDS_DIR . '*.{png,jpg,jpeg}', GLOB_BRACE) ?: [];

$filter = $_GET['filter'] ?? 'all';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Biblioteca - VOD Generator</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f5f5;
            display: flex;
        }
        
        .sidebar {
            width: 250px;
            background: <?php echo COLOR_METALIC; ?>;
            color: white;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            overflow-y: auto;
        }
        
        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h3 {
            color: <?php echo COLOR_NEON; ?>;
            margin-top: 10px;
        }
        
        .menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .menu li {
            padding: 10px 20px;
            transition: background 0.3s;
        }
        
        .menu li:hover {
            background: rgba(0,255,255,0.1);
        }
        
        .menu li.active {
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
        }
        
        .menu li a {
            color: white;
            text-decoration: none;
            display: block;
        }
        
        .menu li i {
            margin-right: 10px;
            width: 20px;
        }
        
        .main-content {
            margin-left: 250px;
            flex: 1;
            padding: 20px;
        }
        
        .top-menu {
            background: white;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .page-title {
            color: <?php echo COLOR_METALIC; ?>;
            font-size: 24px;
            font-weight: bold;
        }
        
        .filter-tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }
        
        .filter-tab {
            padding: 10px 20px;
            background: white;
            border: 2px solid #e0e0e0;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
            color: #666;
            transition: all 0.3s;
        }
        
        .filter-tab:hover,
        .filter-tab.active {
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
            border-color: <?php echo COLOR_NEON; ?>;
        }
        
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .content-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }
        
        .content-item {
            background: #f8f9fa;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            transition: transform 0.3s;
        }
        
        .content-item:hover {
            transform: translateY(-5px);
        }
        
        .content-image {
            width: 100%;
            height: 300px;
            object-fit: cover;
        }
        
        .content-info {
            padding: 15px;
        }
        
        .content-title {
            font-weight: bold;
            margin-bottom: 5px;
            color: <?php echo COLOR_METALIC; ?>;
        }
        
        .content-date {
            font-size: 12px;
            color: #999;
            margin-bottom: 10px;
        }
        
        .content-actions {
            display: flex;
            gap: 10px;
        }
        
        .btn-small {
            flex: 1;
            padding: 8px;
            background: <?php echo COLOR_NEON; ?>;
            color: <?php echo COLOR_METALIC; ?>;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 12px;
            font-weight: bold;
            transition: transform 0.3s;
        }
        
        .btn-small:hover {
            transform: scale(1.05);
        }
        
        .empty-state {
            text-align: center;
            padding: 40px;
            color: #999;
        }
        
        .empty-state i {
            font-size: 48px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="sidebar-header">
            <i class="fas fa-film" style="font-size: 40px; color: <?php echo COLOR_NEON; ?>;"></i>
            <h3>VOD Generator</h3>
        </div>
        
        <ul class="menu">
            <li><a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a></li>
            <li><a href="gerar_banners.php"><i class="fas fa-plus-circle"></i> Gerar Banners</a></li>
            <li><a href="gerar_cards.php"><i class="fas fa-image"></i> Gerar Cards</a></li>
            <li><a href="gerar_jogos.php"><i class="fas fa-futbol"></i> Cards Jogos</a></li>
            <li><a href="temas_vod.php"><i class="fas fa-palette"></i> Temas VOD</a></li>
            <li><a href="temas_jogos.php"><i class="fas fa-palette"></i> Temas Jogos</a></li>
            <li class="active"><a href="biblioteca.php"><i class="fas fa-layer-group"></i> Biblioteca</a></li>
            <li><a href="perfil.php"><i class="fas fa-user"></i> Perfil</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Sair</a></li>
        </ul>
    </div>
    
    <div class="main-content">
        <div class="top-menu">
            <div class="page-title">
                <i class="fas fa-layer-group"></i> Biblioteca
            </div>
        </div>
        
        <div class="filter-tabs">
            <a href="?filter=all" class="filter-tab <?php echo $filter === 'all' ? 'active' : ''; ?>">
                <i class="fas fa-th"></i> Todos
            </a>
            <a href="?filter=cards" class="filter-tab <?php echo $filter === 'cards' ? 'active' : ''; ?>">
                <i class="fas fa-image"></i> Cards VOD
            </a>
            <a href="?filter=banners" class="filter-tab <?php echo $filter === 'banners' ? 'active' : ''; ?>">
                <i class="fas fa-rectangle-landscape"></i> Banners
            </a>
            <a href="?filter=games" class="filter-tab <?php echo $filter === 'games' ? 'active' : ''; ?>">
                <i class="fas fa-futbol"></i> Cards Jogos
            </a>
        </div>
        
        <div class="container">
            <!-- Cards VOD -->
            <?php if ($filter === 'all' || $filter === 'cards'): ?>
                <h2 style="color: <?php echo COLOR_METALIC; ?>; margin-bottom: 20px;">
                    <i class="fas fa-image"></i> Cards VOD
                </h2>
                
                <?php if (!empty($cards)): ?>
                    <div class="content-grid">
                        <?php foreach (array_reverse($cards) as $card): ?>
                            <div class="content-item">
                                <?php if (file_exists(CARDS_DIR . $card['file'])): ?>
                                    <img src="<?php echo str_replace(ROOT_PATH, '', CARDS_DIR . $card['file']); ?>" class="content-image">
                                <?php endif; ?>
                                <div class="content-info">
                                    <div class="content-title"><?php echo $card['title']; ?></div>
                                    <div class="content-date"><?php echo $card['date']; ?></div>
                                    <div class="content-actions">
                                        <a href="<?php echo str_replace(ROOT_PATH, '', CARDS_DIR . $card['file']); ?>" download class="btn-small">
                                            <i class="fas fa-download"></i> Download
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="empty-state">
                        <i class="fas fa-image"></i>
                        <p>Nenhum card VOD gerado ainda</p>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
            
            <!-- Banners -->
            <?php if ($filter === 'all' || $filter === 'banners'): ?>
                <h2 style="color: <?php echo COLOR_METALIC; ?>; margin-bottom: 20px; margin-top: 40px;">
                    <i class="fas fa-rectangle-landscape"></i> Banners
                </h2>
                
                <?php if (!empty($banners)): ?>
                    <div class="content-grid">
                        <?php foreach (array_reverse($banners) as $banner): ?>
                            <div class="content-item">
                                <img src="<?php echo str_replace(__DIR__, '', $banner); ?>" class="content-image">
                                <div class="content-info">
                                    <div class="content-title"><?php echo basename($banner); ?></div>
                                    <div class="content-date"><?php echo date('Y-m-d H:i:s', filemtime($banner)); ?></div>
                                    <div class="content-actions">
                                        <a href="<?php echo str_replace(__DIR__, '', $banner); ?>" download class="btn-small">
                                            <i class="fas fa-download"></i> Download
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="empty-state">
                        <i class="fas fa-rectangle-landscape"></i>
                        <p>Nenhum banner gerado ainda</p>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
            
            <!-- Games Cards -->
            <?php if ($filter === 'all' || $filter === 'games'): ?>
                <h2 style="color: <?php echo COLOR_METALIC; ?>; margin-bottom: 20px; margin-top: 40px;">
                    <i class="fas fa-futbol"></i> Cards de Jogos
                </h2>
                
                <?php if (!empty($games_cards)): ?>
                    <div class="content-grid">
                        <?php foreach (array_reverse($games_cards) as $game_card): ?>
                            <div class="content-item">
                                <img src="<?php echo str_replace(__DIR__, '', $game_card); ?>" class="content-image">
                                <div class="content-info">
                                    <div class="content-title"><?php echo basename($game_card); ?></div>
                                    <div class="content-date"><?php echo date('Y-m-d H:i:s', filemtime($game_card)); ?></div>
                                    <div class="content-actions">
                                        <a href="<?php echo str_replace(__DIR__, '', $game_card); ?>" download class="btn-small">
                                            <i class="fas fa-download"></i> Download
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="empty-state">
                        <i class="fas fa-futbol"></i>
                        <p>Nenhum card de jogo gerado ainda</p>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
