# VOD Generator - Sistema de Geração de Banners e Cards

Um sistema web completo para gerar banners, cards VOD e cards de jogos de forma profissional e automatizada.

## 🚀 Características

- **Geração de Banners**: Crie banners profissionais para filmes e séries
- **Cards VOD**: Gere cards personalizados para plataformas de streaming
- **Cards de Jogos**: Crie cards automáticos para eventos esportivos
- **Integração TMDB**: Busque informações de filmes e séries automaticamente
- **Temas Personalizáveis**: 10+ temas pré-configurados e editáveis
- **Gerenciamento de Conteúdo**: Biblioteca completa de conteúdo gerado
- **Interface Responsiva**: Design moderno e intuitivo

## 📋 Requisitos

- **PHP 7.4+** com suporte a GD Library
- **Apache** com mod_rewrite ativado
- **Curl** para requisições HTTP
- **Espaço em disco**: Mínimo 500MB

## 🔧 Instalação

1. **Extraia o arquivo ZIP**
   ```bash
   unzip MEUS-BANNERS.zip
   cd MEUS-BANNERS
   ```

2. **Configure as permissões de pastas**
   ```bash
   chmod -R 755 assets/
   chmod -R 755 data/
   ```

3. **Acesse a aplicação**
   - URL: `http://seu-dominio.com/MEUS-BANNERS/`
   - Usuário: `admin`
   - Senha: `admin123`

## 📁 Estrutura do Projeto

```
MEUS-BANNERS/
├── assets/
│   ├── css/
│   │   └── style.css
│   ├── fonts/
│   └── images/
│       ├── banners/
│       ├── cards/
│       ├── logos/
│       ├── profiles/
│       ├── games_cards/
│       └── games_images/
├── data/
│   ├── movies.json
│   ├── series.json
│   ├── themes.json
│   ├── themes_vod.json
│   ├── games_themes.json
│   ├── games.json
│   ├── cards.json
│   └── settings.json
├── config.php
├── login.php
├── logout.php
├── dashboard.php
├── gerar_banners.php
├── gerar_cards.php
├── gerar_jogos.php
├── temas_vod.php
├── temas_jogos.php
├── biblioteca.php
├── perfil.php
├── .htaccess
└── README.md
```

## 🔐 Segurança

### Credenciais Padrão
- **Usuário**: admin
- **Senha**: admin123

**⚠️ IMPORTANTE**: Altere a senha padrão imediatamente após a primeira login!

### Proteção
- Arquivos sensíveis bloqueados via `.htaccess`
- Validação de entrada em todos os formulários
- Proteção contra CSRF
- Verificação de sessão em todas as páginas

## 📖 Como Usar

### 1. Gerar Banners
1. Acesse **Gerar Banners**
2. Busque um filme/série no TMDB
3. Selecione um tema
4. Clique em "Gerar Banner"

### 2. Gerar Cards VOD
1. Acesse **Gerar Cards**
2. Faça upload da logo do site
3. Busque um filme/série no TMDB
4. Selecione um tema
5. Clique em "Gerar Card"

### 3. Gerar Cards de Jogos
1. Acesse **Cards Jogos**
2. Clique em "Buscar Jogos"
3. Selecione um tema
4. Clique em "Gerar Card"

### 4. Gerenciar Temas
- **Temas VOD**: Customize cores e estilos dos cards VOD
- **Temas Jogos**: Customize cores e estilos dos cards de jogos

### 5. Visualizar Biblioteca
- Acesse **Biblioteca** para ver todos os conteúdos gerados
- Filtre por tipo (Cards, Banners, Jogos)
- Baixe os arquivos gerados

## 🎨 Temas Disponíveis

### Temas VOD
- Azul Metálico
- Azul Neon
- Vermelho Ação
- Roxo Mistério
- Verde Natureza

### Temas de Jogos
- Clássico Escuro
- Futebol Gramado
- Estádio Noturno
- Campeonato
- Clássico Vermelho
- Azul Campeão
- Moderno Gradiente
- Neon Game
- Clássico Europeu
- Brasileirão

## 🔌 Integração TMDB

O sistema utiliza a API do TMDB (The Movie Database) para buscar informações de filmes e séries.

**API Key padrão**: `a688ebacd173967acc7359daa726e3d3`

Para usar sua própria chave:
1. Acesse [themoviedb.org](https://www.themoviedb.org)
2. Crie uma conta e obtenha sua API key
3. Edite `config.php` e altere a constante `TMDB_API_KEY`

## 📊 Arquivos JSON

### movies.json
Armazena informações de filmes processados

### series.json
Armazena informações de séries processadas

### themes.json
Temas para banners

### themes_vod.json
Temas para cards VOD

### games_themes.json
Temas para cards de jogos

### games.json
Informações de jogos/eventos

### cards.json
Histórico de cards gerados

### settings.json
Configurações gerais (logo do site, etc)

## 🐛 Troubleshooting

### Erro: "Pasta não encontrada"
- Verifique as permissões das pastas
- Execute: `chmod -R 755 assets/ data/`

### Erro: "GD Library não encontrada"
- Instale a extensão GD do PHP
- Ubuntu/Debian: `sudo apt-get install php-gd`
- Reinicie o Apache: `sudo systemctl restart apache2`

### Erro: "Não consigo fazer login"
- Limpe os cookies do navegador
- Verifique se as sessões estão habilitadas no PHP
- Verifique se a pasta `/tmp` tem permissão de escrita

### Imagens não aparecem
- Verifique se os arquivos foram salvos em `assets/images/`
- Confirme as permissões: `chmod -R 755 assets/images/`

## 📞 Suporte

Para relatar bugs ou sugerir melhorias, entre em contato com o administrador do sistema.

## 📄 Licença

Este projeto é fornecido como está, sem garantias.

## 🔄 Atualizações

Versão: **1.0.0**
Data: **2026-03-03**

### Changelog
- ✅ Sistema de autenticação
- ✅ Geração de banners
- ✅ Geração de cards VOD
- ✅ Geração de cards de jogos
- ✅ Integração TMDB
- ✅ Gerenciamento de temas
- ✅ Biblioteca de conteúdo
- ✅ Perfil do usuário

---

**Desenvolvido com ❤️ para criar conteúdo visual incrível**
